# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdvaluevector import *
from .sdapiobject import *
from .sdbasetypes import *
from .sdapiobject import *
from .apiexception import APIException

class SDValueDouble3(SDValueVector):
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDValueDouble3
        """
        super(SDValueDouble3, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew(value : double3) -> SDValueDouble3:
        """
        Create new SDValueDouble3

        :param value: The name of the enum type
        """
        outSDValueDouble3 = ctypes.c_void_p()
        _res = sd.getContext().SDValueDouble3_sNew(ctypes.byref(value), ctypes.byref(outSDValueDouble3))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outSDValueDouble3, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outSDValueDouble3.value, ownHandle=True)

    def get(self) -> double3:
        """
        Get the base type value as double3

        """
        outValue = double3()
        _res = self.mAPIContext.SDValueDouble3_get(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue

